﻿using System.Collections.Generic;
using System;

namespace Marimo.開発支援.コンソールアプリケーションライブラリ
{
    /// <summary>
    /// コマンドライン引数を判断するための情報を管理し、また指定されたコマンドライン引数を解読します。
    /// </summary>
    public class コマンドライン引数管理
    {
        /// <summary>
        /// 実際の操作を管理するクラスのインスタンスです。
        /// </summary>
        private static コマンドライン引数操作 操作;

        /// <summary>
        /// 静的コンストラクタです。初回の利用の前に初期化を行います。
        /// </summary>
        static コマンドライン引数管理()
        {
            初期化する();
        }

        /// <summary>
        /// /?、-?コマンドにより表示される説明を取得、設定します。
        /// </summary>
        public static string 説明 { get; set; }

        /// <summary>
        /// 指定されたコマンドの大文字小文字を区別するかどうかを取得、設定します。
        /// </summary>
        public static bool 大文字小文字を区別する
        {
            get { return 操作.大文字小文字を区別する; }
            set { 操作.大文字小文字を区別する = value; }
        }

        /// <summary>
        /// コマンドを登録します。
        /// </summary>
        /// <param name="コマンドキー">登録するコマンドをあらわす文字列。先頭のスラッシュやハイフンを除いて指定します。</param>
        public static void コマンドを登録する(string コマンドキー)
        {
            コマンドを登録する(new コマンド(コマンドキー));
        }

        /// <summary>
        /// コマンドを登録します。
        /// </summary>
        /// <param name="コマンド">登録するコマンド。</param>
        public static void コマンドを登録する(コマンド コマンド)
        {
            操作.コマンドを登録する(コマンド);
        }

        /// <summary>
        /// すべての登録の初期化を行います。
        /// </summary>
        public static void 初期化する()
        {
            操作 = new コマンドライン引数操作();
            コマンドを登録する("?");
            説明 = string.Empty;
        }

        /// <summary>
        /// コマンド引数として指定された文字列配列を指定し、コマンド一覧を取得します。?コマンドが指定された場合は標準出力に説明を表示します。
        /// </summary>
        /// <param name="args">コマンド引数として指定された文字列配列。</param>
        /// <returns>コマンド一覧。</returns>
        public static Dictionary<string, string> コマンド一覧を取得する(string[] args)
        {
            Dictionary<string, string> 戻り値 = 操作.コマンド一覧を取得する(args);

            Console.WriteLine(説明);

            return 戻り値;
        }
    }
}